@echo off
echo. #############################################################################
echo.									      
echo. This utility will deploy the EMDK for Android device runtime on connected   
echo. Symbol Android devices. 					      
echo. 									      
echo. (C) 2014 Symbol Technologies, Inc. All rights reserved.		      
echo. 									      
echo. IMPORTANT: Connect the Android device before proceeding! 	
echo.								      				
echo. #############################################################################

echo:
pause

echo:
echo Starting adb server...
echo:
adb start-server

echo:
echo Querying the state of the connected device...
echo:

:query_state
set theValue=
for /f "delims=" %%a in ('adb get-state') do @set theValue=%%a

if "%theValue%" == "unknown" goto no_device
if "%theValue%" == "no device" goto no_device
if "%theValue%" == "offline" goto offline_device
if "%theValue%" == "device" goto connected_device

:install_apk
echo:
echo Installing EMDK OS update apk...
echo:

if not exist "EmdkOSUpdateApp*.apk" goto missing_apk
adb install EmdkOSUpdateApp*.apk

:start_OSupdate
echo:
echo Starting OS update... 
echo:

adb shell am start -n com.symbol.emdkosupdater/.MainActivity
goto wait_success

:wait_failed
echo:
echo The EMDK for Android device runtime deployment process has terminated!
echo:
pause
goto exit_process

:wait_success
echo:
echo The EMDK for Android device runtime deployment process has completed!
echo The device will reboot to finish the update...
echo:
pause
goto exit_process

:exit_process
echo:
echo Stoping adb server...
echo:
adb kill-server
exit

:missing_apk
echo:
echo FAILED: The OS update apk is missing. The EMDK for Android device runtime cannot be installed.
echo:
goto wait_failed

:no_device
echo:
echo  FAILED: There is no device connected. Connect a device and try again. 
echo:
goto wait_failed

:offline_device
echo:
echo FAILED: The device instance is not connected to adb or is not responding.
echo:
goto wait_failed

:connected_device
echo:
echo SUCESS: The device instance is now connected to the adb server.
echo:
goto install_apk